/* 
 *  MonitoredInteractionEventTask.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.MonitoredInteractionI;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.enums.NotificationType;

import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;

public class MonitoredInteractionEventTask extends Task<MonitoredInteractionData> {

    private final NotificationEventI<MonitoredInteractionI> interaction;
    private final SupervisorDataGUI gui;
    private static final Logger LOG = Logger.getLogger(MonitoredInteractionEventTask.class);

    public MonitoredInteractionEventTask(NotificationEventI<MonitoredInteractionI> resource, SupervisorDataGUI gui) {
        this.interaction = resource;
        this.gui = gui;
        setupJavaFXApplicationSucceededHandler();
    }

    private void setupJavaFXApplicationSucceededHandler() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            MonitoredInteractionData value = (MonitoredInteractionData) t.getSource().getValue();
            if (value != null) {
                if (!value.isDeleted())
                    LOG.info(methodName + "MonitoredInteractionData:" + value);
                else
                    LOG.info(methodName + "Deletion of MonitoredInteractionData-ID:" + value.getId());
                gui.updateMonitoredInteraction(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }

    @Override
    protected MonitoredInteractionData call() throws Exception {
        String methodName = "call() ";
        MonitoredInteractionData data = null;
        NotificationType type = interaction.getNotificationType();
        LOG.debug(methodName + "Type:" + type + " ID:" + interaction.getNotificationObject().getId());

        switch (type) {
        case UPDATE:
            LOG.debug(methodName + "UPDATE:");
            data = new MonitoredInteractionData(interaction.getNotificationObject());
            break;
        case DELETE:
            LOG.debug(methodName + "DELETE:");
            data = new MonitoredInteractionData(interaction.getNotificationObject().getId(), true);
            break;
        case ERROR:
            LOG.errorStatus(interaction.getError());
            break;
        case NEW:
            LOG.debug(methodName + "NEW:");
            data = new MonitoredInteractionData(interaction.getNotificationObject());
            break;
        case RESPONSE:
            LOG.debug(methodName + "RESPONSE:");
            break;
        case UNKNOWN:
            LOG.debug(methodName + "UNKNOWN:");
            break;
        }
        LOG.trace(methodName + "InteractionData " + (data == null ? "<NULL>" : data.toString()));
        return data;
    }
}
